/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.launcher;

import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.OverlapType;
import technology.rocketjump.undermount.assets.model.RoomEdgeType;
import technology.rocketjump.undermount.assets.model.WallType;
import technology.rocketjump.undermount.entities.SequentialIdGenerator;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.launcher.exceptions.ModParsingException;
import technology.rocketjump.undermount.launcher.loading.EntityAssetLoader;
import technology.rocketjump.undermount.launcher.loading.GuiAssetLoader;
import technology.rocketjump.undermount.launcher.loading.SunlightPhaseParser;
import technology.rocketjump.undermount.launcher.model.ModManifest;
import technology.rocketjump.undermount.launcher.model.TerrainAssetDescriptor;

public class ModLoader {
    private ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, OverlapType> overlapTypesByName = new HashMap<String, OverlapType>();

    public ModManifest parseModDir(FileHandle modBaseDir) throws IOException {
        ModManifest manifest = new ModManifest();
        manifest.setBaseDir(modBaseDir);
        this.loadDefinitions(manifest);
        this.loadTerrainInfo(manifest);
        if (modBaseDir.child("entities").exists()) {
            manifest.setEntityAssetManifest(new EntityAssetLoader().parse(modBaseDir.child("entities")));
            for (PlantSpecies plantSpecies : manifest.getEntityAssetManifest().getPlantSpeciesList()) {
                if (plantSpecies.getBranchMaterial() == null) continue;
                manifest.getDefinedMaterials().add(plantSpecies.getBranchMaterial());
            }
        }
        manifest.setGuiManifest(new GuiAssetLoader().parse(modBaseDir));
        if (modBaseDir.child("translations").exists() && modBaseDir.child("translations").child("languages.json").exists()) {
            manifest.getTranslationFiles().add(modBaseDir.child("translations").child("languages.json"));
            manifest.getI18nCollator().init(modBaseDir.child("translations"));
        }
        if (modBaseDir.child("music").exists()) {
            for (FileHandle fileHandle : modBaseDir.child("music").list()) {
                if (!fileHandle.extension().equals("ogg")) continue;
                manifest.getMusicFiles().add(fileHandle);
            }
        }
        if (modBaseDir.child("text").exists()) {
            for (FileHandle fileHandle : modBaseDir.child("text").list()) {
                if (!fileHandle.isDirectory()) continue;
                manifest.getTextDirectories().add(fileHandle);
            }
        }
        return manifest;
    }

    private void loadTerrainInfo(ModManifest manifest) throws IOException {
        FileHandle spritesDir = manifest.getBaseDir().child("sprites");
        if (spritesDir.exists()) {
            FileHandle masksDir;
            if (spritesDir.child("pack.json").exists()) {
                manifest.setSpritesPackJson(spritesDir.child("pack.json"));
            }
            if (spritesDir.child("floors").exists()) {
                for (FileHandle floorSpriteDir : spritesDir.child("floors").list()) {
                    if (!floorSpriteDir.isDirectory()) continue;
                    manifest.getTerrainAssetDescriptors().add(this.loadFloorSpriteDescriptor(floorSpriteDir, manifest));
                }
            }
            if (spritesDir.child("walls").exists()) {
                for (FileHandle wallSpriteDir : spritesDir.child("walls").list()) {
                    if (!wallSpriteDir.isDirectory()) continue;
                    manifest.getTerrainAssetDescriptors().add(this.loadWallSpriteDescriptor(wallSpriteDir, manifest));
                }
            }
            if (spritesDir.child("masks").exists() && (masksDir = spritesDir.child("masks")).child("edge-overlaps").exists()) {
                FileHandle[] fileHandleArray = masksDir.child("edge-overlaps").list();
                int n = fileHandleArray.length;
                for (int wallSpriteDir = 0; wallSpriteDir < n; ++wallSpriteDir) {
                    FileHandle overlapSpriteDir = fileHandleArray[wallSpriteDir];
                    if (!overlapSpriteDir.isDirectory()) continue;
                    manifest.getTerrainAssetDescriptors().add(this.loadOverlapSpriteDescriptor(overlapSpriteDir, manifest));
                }
            }
            if (spritesDir.child("room-edges").exists()) {
                for (FileHandle roomEdgeSpriteDir : spritesDir.child("room-edges").list()) {
                    if (!roomEdgeSpriteDir.isDirectory()) continue;
                    manifest.getTerrainAssetDescriptors().add(this.loadRoomEdgeSpriteDescriptor(roomEdgeSpriteDir, manifest));
                }
            }
        }
    }

    private TerrainAssetDescriptor loadFloorSpriteDescriptor(FileHandle floorSpriteDir, ModManifest manifest) throws IOException {
        TerrainAssetDescriptor terrainAssetDescriptor = new TerrainAssetDescriptor();
        terrainAssetDescriptor.setDirectory(floorSpriteDir);
        terrainAssetDescriptor.setType("floor");
        FileHandle[] definitionFiles = floorSpriteDir.list("definition.json");
        if (definitionFiles.length != 1) {
            throw new ModParsingException("Could not find a file ending in 'definition.json' in " + floorSpriteDir.path());
        }
        FloorType definition = this.objectMapper.readValue(definitionFiles[0].readString(), FloorType.class);
        definition.setFloorTypeId(SequentialIdGenerator.nextId());
        definition.setOverlapType(this.overlapTypesByName.get(definition.getOverlapType().getOverlapName()));
        terrainAssetDescriptor.setFloorType(definition);
        for (int expectedSuffix = 0; expectedSuffix < definition.getNumSprites(); ++expectedSuffix) {
            terrainAssetDescriptor.getDiffuseFiles().add(floorSpriteDir.child(definition.getFloorTypeName() + "_" + expectedSuffix + ".png"));
            terrainAssetDescriptor.getNormalMapFiles().add(floorSpriteDir.child(definition.getFloorTypeName() + "_" + expectedSuffix + "_NORMALS.png"));
        }
        LinkedList<FileHandle> expectedFiles = new LinkedList<FileHandle>();
        expectedFiles.addAll(terrainAssetDescriptor.getDiffuseFiles());
        expectedFiles.addAll(terrainAssetDescriptor.getNormalMapFiles());
        for (FileHandle expectedFile : expectedFiles) {
            if (expectedFile.exists()) continue;
            throw new ModParsingException("Expecting a file named " + expectedFile.name() + " in " + floorSpriteDir.path());
        }
        terrainAssetDescriptor.setHasNormalMaps(true);
        return terrainAssetDescriptor;
    }

    private TerrainAssetDescriptor loadWallSpriteDescriptor(FileHandle wallSpriteDir, ModManifest manifest) throws IOException {
        TerrainAssetDescriptor terrainAssetDescriptor = new TerrainAssetDescriptor();
        terrainAssetDescriptor.setDirectory(wallSpriteDir);
        terrainAssetDescriptor.setType("wall");
        FileHandle[] definitionFiles = wallSpriteDir.list("definition.json");
        if (definitionFiles.length != 1) {
            throw new ModParsingException("Could not find a file ending in 'definition.json' in " + wallSpriteDir.path());
        }
        WallType wallTypeDefinition = this.objectMapper.readValue(definitionFiles[0].readString(), WallType.class);
        wallTypeDefinition.setWallTypeId(SequentialIdGenerator.nextId());
        terrainAssetDescriptor.setWallType(wallTypeDefinition);
        List<String> expectWallNumbers = Arrays.asList("0", "24", "66", "90", "255");
        for (String expectedWallNumber : expectWallNumbers) {
            int alternateLayoutNumber = 0;
            do {
                terrainAssetDescriptor.getDiffuseFiles().add(wallSpriteDir.child(wallTypeDefinition.getWallTypeName() + "_" + expectedWallNumber + "_" + alternateLayoutNumber + ".png"));
                terrainAssetDescriptor.getNormalMapFiles().add(wallSpriteDir.child(wallTypeDefinition.getWallTypeName() + "_" + expectedWallNumber + "_" + alternateLayoutNumber + "_NORMALS.png"));
            } while (wallSpriteDir.child(wallTypeDefinition.getWallTypeName() + "_" + expectedWallNumber + "_" + ++alternateLayoutNumber + ".png").exists());
        }
        LinkedList<FileHandle> expectedFiles = new LinkedList<FileHandle>();
        expectedFiles.addAll(terrainAssetDescriptor.getDiffuseFiles());
        expectedFiles.addAll(terrainAssetDescriptor.getNormalMapFiles());
        for (FileHandle expectedFile : expectedFiles) {
            if (expectedFile.exists()) continue;
            throw new ModParsingException("Expecting a file named " + expectedFile.name() + " in " + wallSpriteDir.path());
        }
        terrainAssetDescriptor.setHasNormalMaps(true);
        return terrainAssetDescriptor;
    }

    private TerrainAssetDescriptor loadRoomEdgeSpriteDescriptor(FileHandle spriteDir, ModManifest manifest) throws IOException {
        TerrainAssetDescriptor terrainAssetDescriptor = new TerrainAssetDescriptor();
        terrainAssetDescriptor.setDirectory(spriteDir);
        terrainAssetDescriptor.setType("room-edge");
        FileHandle[] definitionFiles = spriteDir.list("definition.json");
        if (definitionFiles.length != 1) {
            throw new ModParsingException("Could not find a file ending in 'definition.json' in " + spriteDir.path());
        }
        RoomEdgeType roomEdgeTypeDefinition = this.objectMapper.readValue(definitionFiles[0].readString(), RoomEdgeType.class);
        roomEdgeTypeDefinition.setRoomEdgeTypeId(SequentialIdGenerator.nextId());
        terrainAssetDescriptor.setRoomEdgeType(roomEdgeTypeDefinition);
        List<String> expectedEdgeNumbers = Arrays.asList("0", "24", "66", "90");
        for (String expectedNumber : expectedEdgeNumbers) {
            terrainAssetDescriptor.getDiffuseFiles().add(spriteDir.child(roomEdgeTypeDefinition.getRoomEdgeTypeName() + "_" + expectedNumber + ".png"));
        }
        LinkedList<FileHandle> expectedFiles = new LinkedList<FileHandle>();
        expectedFiles.addAll(terrainAssetDescriptor.getDiffuseFiles());
        for (FileHandle expectedFile : expectedFiles) {
            if (expectedFile.exists()) continue;
            throw new ModParsingException("Expecting a file named " + expectedFile.name() + " in " + spriteDir.path());
        }
        terrainAssetDescriptor.setHasNormalMaps(false);
        return terrainAssetDescriptor;
    }

    private TerrainAssetDescriptor loadOverlapSpriteDescriptor(FileHandle overlapSpriteDir, ModManifest manifest) throws ModParsingException {
        TerrainAssetDescriptor terrainAssetDescriptor = new TerrainAssetDescriptor();
        terrainAssetDescriptor.setDirectory(overlapSpriteDir);
        terrainAssetDescriptor.setType("overlap");
        OverlapType overlapType = this.findOverlapType(overlapSpriteDir.name(), manifest.getAlphaMaskOverlapTypes());
        terrainAssetDescriptor.setOverlapType(overlapType);
        terrainAssetDescriptor.getAlphaMaskFiles().addAll(Arrays.asList(overlapSpriteDir.list()));
        return terrainAssetDescriptor;
    }

    private void loadDefinitions(ModManifest manifest) throws IOException {
        FileHandle environmentDir;
        FileHandle definitionsDir = manifest.getBaseDir().child("definitions");
        if (definitionsDir.exists()) {
            for (FileHandle definitionsFile : definitionsDir.list()) {
                if (definitionsFile.name().contains("materials.json")) {
                    this.loadMaterialDefinitions(definitionsFile, manifest.getDefinedMaterials());
                    continue;
                }
                if (definitionsFile.name().equals("overlapTypes.json")) {
                    this.loadOverlapDefinitions(manifest.getAlphaMaskOverlapTypes(), definitionsDir.child("overlapTypes.json"));
                    continue;
                }
                if (!definitionsFile.name().endsWith(".json")) continue;
                manifest.getOtherDefinitionFiles().add(definitionsFile);
            }
        }
        if ((environmentDir = manifest.getBaseDir().child("environment")).exists() && environmentDir.child("sunlight.json").exists()) {
            manifest.setSunlightPhases(new SunlightPhaseParser(environmentDir.child("sunlight.json")).parseSunlightPhases());
        }
        manifest.getOtherDefinitionFiles().add(manifest.getBaseDir().child("jobs").child("professions.json"));
        manifest.getOtherDefinitionFiles().add(manifest.getBaseDir().child("jobs").child("craftingTypes.json"));
        manifest.getOtherDefinitionFiles().add(manifest.getBaseDir().child("rooms").child("roomTypes.json"));
    }

    private void loadMaterialDefinitions(FileHandle materialsDefinitions, List<GameMaterial> currentMaterials) throws IOException {
        try {
            List materialsFromFile = (List)this.objectMapper.readValue(materialsDefinitions.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, GameMaterial.class));
            for (GameMaterial gameMaterial : materialsFromFile) {
                gameMaterial.setMaterialId(SequentialIdGenerator.nextId());
                currentMaterials.add(gameMaterial);
            }
        }
        catch (IOException e) {
            throw new ModParsingException("Could not read JSON array from " + materialsDefinitions.path(), e);
        }
    }

    private void loadOverlapDefinitions(List<OverlapType> currentTypes, FileHandle overlapDefinitions) throws IOException {
        try {
            List overlapTypes = (List)this.objectMapper.readValue(overlapDefinitions.readString(), this.objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, OverlapType.class));
            for (OverlapType overlapType : overlapTypes) {
                overlapType.setOverlapTypeId(SequentialIdGenerator.nextId());
                this.overlapTypesByName.put(overlapType.getOverlapName(), overlapType);
                currentTypes.add(overlapType);
            }
        }
        catch (IOException e) {
            throw new ModParsingException("Could not read JSON array from " + overlapDefinitions.path(), e);
        }
    }

    private GameMaterial findMaterial(String materialName, List<GameMaterial> definedMaterials) throws ModParsingException {
        for (GameMaterial definedMaterial : definedMaterials) {
            if (!definedMaterial.getMaterialName().equalsIgnoreCase(materialName)) continue;
            return definedMaterial;
        }
        throw new ModParsingException("Unrecognised material " + materialName + " in sprite definition.json. Recognised materials are " + definedMaterials.toString());
    }

    private OverlapType findOverlapType(String overlapTypeName, List<OverlapType> alphaMaskOverlapTypes) throws ModParsingException {
        for (OverlapType definedType : alphaMaskOverlapTypes) {
            if (!definedType.getOverlapName().equalsIgnoreCase(overlapTypeName)) continue;
            return definedType;
        }
        throw new ModParsingException("Unrecognised overlap type " + overlapTypeName + " in sprite definition.json. Recognised types are " + alphaMaskOverlapTypes.toString());
    }
}

